#ifndef _MFS_USB_h_
#define _MFS_USB_h_
/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: MFS_USB.h$
* $Version : 3.0.4.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   
*
*END************************************************************************/

#include <mqx.h>
#include <bsp.h>
#include <lwevent.h>
#include <message.h>
#include <mfs.h>
#include <part_mgr.h>
#include <usbmfs.h>


#define DEMOCFG_USE_POOLS             0   /* enable external memory pools for USB */

#if BSP_M52259EVB
    #define DEMOCFG_MFS_POOL_ADDR  (uint_32)(BSP_EXTERNAL_MRAM_RAM_BASE)
    #define DEMOCFG_MFS_POOL_SIZE  0x00010000
#elif DEMOCFG_USE_POOLS
    #warning External pools will not be used on this board.
#endif

#include <shell.h>


extern void Shell_Task(uint_32);
extern void USB_task(uint_32);
extern void Main_task(uint_32);
extern void Sampler_task(uint_32);
extern void Logging_task(uint_32);



extern uint_32 samplerprogresscount;

#define LOGGER_TASK 4
#define SAMPLER_TASK 5

//Defines for the LEDs
#define LED_1 BSP_LED1
#define LED_2 BSP_LED2
#define LED_3 BSP_LED3
#define LED_4 BSP_LED4




#endif
